package it.unicam.pizzeria4.servizio;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

import it.unicam.pizzeria4.util.DettagliMenu;
import it.unicam.pizzeria4.util.DettagliComanda;
import it.unicam.pizzeria4.util.DettagliPortata;

public class Comanda {
	String ID;

	private long oraApertura;
	private int numCoperti;
	Vector<Ordinazione> ordinazioni;
	
	public Comanda(String ID, int numCoperti) {
		this.ID = ID;
		this.numCoperti = numCoperti;
		this.oraApertura = (new Date()).getTime();
		this.ordinazioni = new Vector<Ordinazione>();
	}

	public String getID() {
		return ID;
	}
	
	public DettagliComanda getDettagli() {
		Iterator<Ordinazione> dmi = ordinazioni.iterator();
        DettagliPortata[] listaPortate = new DettagliPortata[ordinazioni.size()];		
		Ordinazione ec;
		DettagliPortata dp;
		int i=0;
		while (dmi.hasNext()) {
			ec = dmi.next();
			DettagliMenu ordinazione = new DettagliMenu(ec.getID(), ec.getNome(), ec.getTipo(), ec.getPrezzo(),
					"Ingredienti:" + ec.getIngredienti() + "\nIntolleranze:" + ec.getIntolleranze());
			dp = new DettagliPortata();
			dp.setNote(ec.getNote());
			dp.setQuantita(ec.getQuantita());
			dp.setOrdinazione(ordinazione);
			dp.setOrdine(0);
			listaPortate[i++] = dp;
		}
		return new DettagliComanda(ID,listaPortate);
	}

	/**
	 * 
	 * @param piatto
	 * @param quantita
	 */
	public void aggiungiPortata(Piatto piatto, int quantita) {
		Iterator<Ordinazione> oi = ordinazioni.iterator();
		Ordinazione ordinazione = null;
		boolean trovato = false;
		while (!trovato & oi.hasNext()) {
			ordinazione = oi.next();
			if (ordinazione.getID().equals(piatto.getID())) trovato = true;
		}
		if (trovato) {
			ordinazione.setQuantita(quantita);
		} else {
			Portata portata = new Portata(piatto,quantita);
			ordinazioni.add(portata);
		}
	}

	/**
	 * 
	 * @param bibita
	 * @param quantita
	 */
	public void aggiungiBevanda(Bibita bibita, int quantita) {
		Iterator<Ordinazione> oi = ordinazioni.iterator();
		Ordinazione ordinazione = null;
		boolean trovato = false;
		while (!trovato & oi.hasNext()) {
			ordinazione = oi.next();
			if (ordinazione.getID().equals(bibita.getID())) trovato = true;
		}
		if (trovato) {
			ordinazione.setQuantita(quantita);
		} else {
			Bevanda bevanda = new Bevanda(bibita,quantita);
			ordinazioni.add(bevanda);
		}
	}

	public ArrayList<Portata> getPortate() {
		Iterator<Ordinazione> oi = ordinazioni.iterator();
		ArrayList<Portata> listaPortate = new ArrayList<Portata>();
		Ordinazione ordinazione = null;
		while (oi.hasNext()) {
			ordinazione = oi.next();
			if (ordinazione instanceof Portata) {
				listaPortate.add((Portata)ordinazione);
			}
		}
		return listaPortate;
	}

}
